# 程序员 AI 绘图完全指南

> 1 分钟生成架构图，告别手工画图



你好，我是程序员鱼皮。

作为一名程序员，画图可以说是工作中的家常便饭了。无论是给领导汇报时画架构图、还是写文档时画流程图、或者头脑风暴时画思维导图，画图能力直接体现出我们的专业水平。

以前画图需要自己费时费力，一个复杂的架构图可能要花几个小时，还得反复调整；现在喝杯水的功夫，AI 就帮你画好了，而且效果还特别专业！

下面我将分享 **5 大类 AI 画图方法**，每一种都有详细的保姆级教程。这些方法一个比一个猛，建议先点赞收藏。以后无论是生成原型图、设计海报，还是程序员常画的架构图、流程图、UML 类图等等，都是洒洒水的事~

⭐️ 推荐观看视频版，有更详细的操作演示：https://bilibili.com/video/BV1DP7JzAE7k



## AI 画图的本质

在开始之前，我们先了解一下 AI 画图的本质：**其实就是让 AI 生成各种绘图工具能够理解的文本代码**，然后将这些代码导入到对应的工具中进行渲染。

这样就能够借助 AI 的创意和工具的能力自由地生成图片。

![AI 画图原理](https://pic.yupi.icu/1/1748414656182-9580e13e-97bd-4013-8361-ee19b200c0f7.png)

虽然目前主流的 AI 大模型和工具都能实现画图功能，但我强烈建议使用 **Cursor 工具搭配 Claude 4 大模型**，效果最佳。

下面来介绍几类 AI 画图方法：



## 一、文本绘图

文本绘图是最受高级程序员欢迎的画图方式，通过简单的文本描述就能生成专业的技术图。主流的文本绘图语言包括 **Mermaid** 和 **PlantUML**。



### Mermaid - 最流行的文本绘图工具

Mermaid 是目前最流行的文本绘图工具，语法简单直观，被 GitHub、语雀等大平台原生支持。无论你是要画软件架构图、业务流程图，还是数据库 ER 图、Git 分支图，Mermaid 都能轻松搞定。

让我们先来画一个用户登录流程图，只需要给 AI 这样的提示词：

```plain
请用 Mermaid 语法帮我画一个用户登录流程图，包含以下步骤：
1. 用户输入账号密码
2. 前端校验格式
3. 发送请求到后端
4. 后端验证用户信息
5. 如果验证成功，生成 token 返回
6. 如果失败，返回错误信息
7. 前端根据结果跳转页面或显示错误
```

放到 Cursor 等 AI 工具中执行，AI 会生成 Mermaid 代码。然后你可以把代码复制到支持 Mermaid 的工具中查看效果，比如语雀、Typora、或者在线的 [Mermaid 渲染网站](https://mermaid-live.nodejs.cn/edit)。

![Mermaid 流程图](https://pic.yupi.icu/1/1748414916480-1151faa7-a03d-49b0-82b0-ba321211456e.png)

很多 AI 聊天助手内置了 Mermaid 渲染工具，能直接看到效果并下载：

![AI 内置渲染](https://pic.yupi.icu/1/1748415298510-f1389787-6859-4cf6-b0c7-fe6712acf57a.png)

Mermaid 还支持多种图表类型，比如时序图、甘特图、饼图、Git 分支图、架构图等。



### PlantUML - 专业的 UML 绘图工具

PlantUML 是另一个强大的文本绘图工具，特别擅长绘制 UML 图、时序图和系统架构图。它的语法相对 Mermaid 更加专业和规范，生成的图表也更加精美。

让我们用 AI + PlantUML 画一个经典的订单系统类图：

```plain
请用 PlantUML 语法帮我画一个订单系统的类图，包含：
- Order 类：订单ID、用户ID、总金额、状态、创建时间
- OrderItem 类：商品ID、数量、单价
- User 类：用户ID、用户名、邮箱
- Product 类：商品ID、名称、价格、库存
展示它们之间的关联关系
```

AI 会生成专业的 PlantUML 代码，同样放到语雀的文本绘图、或者 [PlantUML 渲染网站](https://www.plantuml.com/plantuml/uml/) 中，都可以看到效果。

![PlantUML 类图](https://pic.yupi.icu/1/image-20250530125534018.png)



### 如何选择？

| 特性         | **Mermaid**              | **PlantUML**      | **Graphviz**       |
| ------------ | ------------------------ | ----------------- | ------------------ |
| **图表类型** | 流程图、时序图、甘特图等 | UML全系列、架构图 | 各类图表，极其灵活 |
| **语法难度** | 简单直观                 | 中等，UML规范     | 较复杂             |
| **生态支持** | GitHub/GitLab原生支持    | 需要插件支持      | 广泛支持           |
| **适用场景** | 日常文档配图             | 专业架构设计      | 复杂网络拓扑       |

我的建议是，日常使用选 Mermaid，因为它语法简单、平台支持好；如果要画专业的 UML 图，就选 PlantUML。



## 二、网页绘图

网页绘图是一种非常自由灵活的绘图方式。本质上是 "图片即网站" —— 通过生成包含可视化元素的网页代码，在浏览器中渲染出各种图片。



### 原生网页绘图

利用网站开发的核心技术（HTML + CSS + JavaScript），我们可以生成各种类型的图表。还可以借助各种第三方可视化库（如 ECharts、D3.js 等）来增强效果。

举个例子，当需要展示数据时，AI 可以利用 Apache ECharts 等可视化库生成专业的数据大屏：

```plain
请生成一个数据可视化大屏页面，展示电商平台的实时数据：
1. 页面布局：深色背景的大屏风格
2. 包含以下图表：实时销售额、各品类销售占比、24小时销售趋势、热销商品TOP10、用户地域分布
3. 使用 ECharts 实现，要有动画效果
```

AI 会生成完整的网站，包含各种图表，还是挺炫酷的吧~

![数据大屏](https://pic.yupi.icu/1/1748417511003-49c81cc8-618e-4810-b94d-ebcfbb48885d.png)

你可以直接按需截图，得到图片；还可以通过 [Codepen](https://codepen.io/) 等网站运行工具将生成的网站快速分享给其他人。



### SVG 矢量图绘制

SVG 是可缩放的矢量图形，可以无限缩放而不失真，非常适合绘制 UI 素材、Logo 图标、图形插画、技术架构图、流程图等。

让我们用 SVG 绘制一个系统架构图：

```plain
请生成一个 SVG 格式的系统架构图，展示一个典型的三层架构：
- 展示层：Web 前端、移动端 App
- 业务层：API 服务器集群（3个节点）
- 数据层：主从数据库、Redis 缓存
要求：使用不同颜色区分各层，添加连接线表示数据流向
```

AI 生成的 SVG 代码可以直接保存为 SVG 文件在浏览器内打开。

![SVG 架构图](https://pic.yupi.icu/1/1748419703308-c3e3ab06-bfd0-4d3e-8bd9-6315fe9e3dde.png)



## 三、专业绘图工具 - Draw.io

如果将 AI 与专业绘图工具结合，可以实现 1+1 > 2 的效果。

我用的比较多的绘图工具是免费开源的 **draw.io**，它的优点是自由度极高，支持导入导出多种格式，拥有丰富的图形库和模板。

还有个大火的开源项目 [next-ai-draw-io](https://github.com/DayuanJiang/next-ai-draw-io)，可以直接通过 AI 对话来生成和编辑 draw.io 图片，短短几天就涨了 6k star！

![AI Draw.io](https://pic.yupi.icu/1/1765425690148-db18c63c-6666-4a0b-a681-0ad4a5c061c3.png)

这个项目支持在线体验，你可以完全从 0 开始画图，比如画一个流程图，演示 RAG 的工作原理。AI 会自动生成 Draw.io 绘图代码，很快精美的流程图就搞定了！

⭐️ 建议观看视频演示：https://bilibili.com/video/BV18NmnB4EeM

![RAG 流程图](https://pic.yupi.icu/1/1765425750546-988f6dd9-552b-403f-a1ea-f8866c309663.png)

然后你可以利用 Draw.io 自身强大的绘图能力手动修改任意元素、或者是改变风格样式。也可以通过 AI 对话让它帮你修改，比如改成动画连接线，逼格一下子就上来了。

![动画连接线](https://pic.yupi.icu/1/1765425815484-e879ea8a-d40a-4857-baab-4124c3eedcee.png)



### 生成各种技术图

还有程序员工作涉及的架构图：

```plain
提示词：绘制电商平台的微服务架构图
```

![微服务架构图](https://pic.yupi.icu/1/1765425829760-5337eb51-a51a-4327-a1e0-66b6f4ce2176.png)

UML 类图：

```plain
提示词：用 UML 类图展示用户管理模块的设计
```

![UML 类图](https://pic.yupi.icu/1/1765425843465-53ebe0d1-0df4-46b1-8b27-1bdd98333f5d.png)

ER 图：

```plain
提示词：绘制在线教育平台的数据库 ER 图
```

![ER 图](https://pic.yupi.icu/1/1765425852509-4685b9ff-9c86-430c-9e7e-fd1f75877c51.png)

时序图：

```plain
提示词：用时序图展示用户登录的交互过程
```

![时序图](https://pic.yupi.icu/1/1765425862905-cab2301b-77c2-47e4-adc1-6d7c617cd33b.png)

这些通通不在话下，帮你节省大把的时间和毛发~



### 使用技巧

还有一些使用小技巧，比如配合免费的图标库，让整个绘图元素更丰富：

```plain
提示词：使用 AWS 图标生成 CDN 架构图
```

![AWS 架构图](https://pic.yupi.icu/1/1765426030861-27a70a15-559b-4540-9177-5e5f66d120b0.png)

可以使用原生 SVG 动画标签，给整个绘图增加缩放和路径动画：

```plain
提示词：演示 DDOS 攻击，使用 SVG 的 <animateMotion> 和 <animateTransform type="scale"> 增加缩放和路径动画
```

![动画效果](https://pic.yupi.icu/1/1765425981962-4a730008-8a64-4805-adfc-a63a983e4fde.png)

还可以自己上传一个草图，比如我用文本模型生成的 Mermaid 流程图，让 AI 帮我替换为更美观的样式风格：

```plain
提示词：改为彩虹主题的配色、放大字体、使用加粗动画连接线
```

效果还不错吧！

![优化后的图](https://pic.yupi.icu/1/1765426075534-26f6f2a7-8ee9-421f-ad10-4910b2b7df34.png)

最后导出为各种图片或文档格式，美滋滋~

![导出格式](https://pic.yupi.icu/1/1765268527840-a3717305-7bba-4533-8595-c92c21bcd021.png)



### 本地部署

注意，官方提供的演示网站可能限量和不稳定，像我连续用了几次就被拒绝了。

所以我建议下载开源代码到本地，按照官方文档的说法 [配置自己的大模型](https://github.com/DayuanJiang/next-ai-draw-io/blob/main/docs/ai-providers.md) 来运行；或者用 Docker 一键启动，想怎么用就怎么用。

![Docker 部署](https://pic.yupi.icu/1/1765426188076-914514ec-c5cd-4ac5-8ca7-e09f0808801e.png)



## 四、思维导图

AI 可以帮我们快速生成精美的思维导图，并且能够导出为专业思维导图软件支持的格式。

我用的比较多的思维导图软件是 XMind，支持丰富的样式和主题。

我更建议让 AI 生成 **Markdown 格式的思维导图**，因为 Markdown 格式更通用，方便在各种文档工具中使用：

```plain
请帮我生成一个关于"微服务架构设计"的思维导图，使用 Markdown 格式，用缩进表示层级关系
```

AI 会生成这样的 Markdown 格式：

```markdown
# 微服务架构设计

## 服务拆分原则
- 单一职责
  - 每个服务只负责一个业务功能
  - 高内聚低耦合
- 服务自治
  - 独立部署
  - 独立技术选型
```

将这个 Markdown 文件直接导入 XMind，就能生成结构清晰的思维导图啦！

![思维导图](https://pic.yupi.icu/1/1748422118001-752df2f4-d369-46b8-8e16-cd96191d554f.png)



## 五、AI 绘图技巧


### 技巧 1、提供示例图让 AI 模仿

当你看到一个很棒的图，想要绘制同款时，可以直接截图给 AI，让它帮你生成类似的图。

举个例子，仿照我提供的系统架构图进行生成：

```plain
请根据我提供的系统架构图，用 draw.io 格式生成类似风格和结构的图，但内容改为：
- 一个在线教育平台的架构
- 保持原图的配色方案和布局风格
```

生成结果如图，是不是很像？

![仿照生成](https://pic.yupi.icu/1/1748424880583-92c573bc-fdb2-45d0-b4e0-d2590ea069c5.png)



### 技巧 2、截图标注，精准修改

如果你对 AI 生成的图的有些地方不满意，你可以截图并在需要修改的地方画红圈标注，然后告诉 AI 如何修改。

![标注修改](https://pic.yupi.icu/1/1748424987920-e61af63a-b688-4cf8-8cd5-e05df1d412c9.png)



### 技巧 3、配置专业的系统预设

AI 生成的效果很大程度上取决于输入的提示词，所以要让 AI 画出更专业的图，配置一个好的系统提示词至关重要。

在 Cursor 中，我们可以设置项目级别的 Rules 规则，让 AI 始终遵循你的绘图规范。

给大家一个专业的架构图绘制预设，仅供参考：

```plain
# 技术架构图绘制专家

你是一名资深的系统架构师和技术图表设计专家。

## 绘图原则
1. 所有文字必须使用简体中文
2. 保持图表简洁清晰，避免过度复杂
3. 使用标准的技术图标和符号
4. 配色专业，层次分明

## 配色方案
- 展示层：蓝色系 (#3498db)
- 业务层：绿色系 (#2ecc71)
- 数据层：橙色系 (#e67e22)
```

将这个预设配置到 Cursor Rules 中，AI 就会按照规则来生成图片，确保输出的一致性和专业性。



## 写在最后

看到这里，相信你已经掌握了 AI 画图的各种姿势了！从简单的文本绘图到复杂的动态图表，AI 都能轻松搞定。

不仅能帮我们节省大量时间，而且妈妈再也不用担心我的图画得丑了！

如果你觉得本期内容对你有帮助，别忘了点赞收藏。学编程、对 AI 感兴趣的朋友欢迎关注鱼皮，在我免费开源的 [AI 知识库](https://ai.codefather.cn) 中也汇总了大量 AI 知识和教程干货，希望对大家有帮助。

![](https://pic.yupi.icu/1/image-20260109121412266-20260113153648943.png)




## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
